<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

final class CheckUpgradeRequirementsException extends \Exception
{
    public static function fromUnsupportedPHPVersion(string $versionChange, string $requiredPHPVer): self
    {
        return new self("This type of upgrade($versionChange) requires PHP {$requiredPHPVer} version. Your PHP version is " . phpversion());
    }
}
