<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class CheckPermissionsException extends Exception
{
    public static function fromNonWritableFile(string $file, $moduleId): self
    {
        return new self("The file {$file} is not writable (moduleId: {$moduleId})");
    }

    public static function fromNonWritableDir(string $dir, $moduleId): self
    {
        return new self("The directory {$dir} is not writable (moduleId: {$moduleId})");
    }

    public static function fromAlreadyExistedDir(string $dir, $moduleId): self
    {
        return new self(<<<ERROR
The directory {$dir} already exists (moduleId: {$moduleId}). 
- If you want to install the module from marketplace, remove this directory and retry the command.
- If you want to install the local module, remove {$moduleId} from --install option and add {$moduleId} to --enable option (if you want to enable the module) and retry the command."
ERROR);
    }
}
