<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class AdminCredentialsException extends Exception
{
    public static function fromWrongCredentialsFormat(): self
    {
        return new self('Login and password must be separated by ":"');
    }

    public static function fromWrongLoginFormat(): self
    {
        return new self('Login must be a valid e-mail address');
    }

    public static function fromWrongPasswordFormat(): self
    {
        return new self('Password must be between 8 and 64 characters long');
    }
}
