<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\EventListener;

use App\Output\XCartConsoleOutput;
use Symfony\Component\Console\Event\ConsoleCommandEvent;

class ConsoleListener
{
    private XCartConsoleOutput $consoleOutput;

    public function __construct(
        XCartConsoleOutput $consoleOutput
    ) {
        $this->consoleOutput = $consoleOutput;
    }

    public function onConsoleCommand(ConsoleCommandEvent $event): void
    {
        $this->consoleOutput->setOutput($event->getOutput());
    }
}
