<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Event;

use App\Entity\Scenario;
use App\Output\XCartOutputInterface;
use Symfony\Contracts\EventDispatcher\Event;

final class RunnerEvent extends Event
{
    private Scenario $scenario;

    private XCartOutputInterface $output;

    private string $error;

    public function __construct()
    {
    }

    /**
     * @return Scenario
     */
    public function getScenario(): Scenario
    {
        return $this->scenario;
    }

    /**
     * @param Scenario $scenario
     *
     * @return RunnerEvent
     */
    public function setScenario(Scenario $scenario): RunnerEvent
    {
        $this->scenario = $scenario;

        return $this;
    }

    /**
     * @return XCartOutputInterface
     */
    public function getOutput(): XCartOutputInterface
    {
        return $this->output;
    }

    /**
     * @param XCartOutputInterface $output
     *
     * @return RunnerEvent
     */
    public function setOutput(XCartOutputInterface $output): RunnerEvent
    {
        $this->output = $output;

        return $this;
    }

    /**
     * @return string
     */
    public function getError(): string
    {
        return $this->error;
    }

    /**
     * @param string $error
     *
     * @return RunnerEvent
     */
    public function setError(string $error): RunnerEvent
    {
        $this->error = $error;

        return $this;
    }
}
