<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiProperty;
use App\Controller\VersionsController;
use App\Domain\XCart;
use App\Marketplace\Marketplace;
use App\Repository\LicenseRepository;
use App\Repository\ModuleRepository;
use Symfony\Component\Uid\UuidV4;

/**
 * @ApiResource(
 *     paginationEnabled=false,
 *     collectionOperations={
 *          "get"={
 *              "controller"=VersionsController::class,
 *              "openapi_context"={
 *                  "parameters"={}
 *             },
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *              "controller"=NotFoundAction::class,
 *              "read"=false,
 *              "output"=false,
 *          }
 *     }
 * )
 */
class Version
{
    /**
     * @ApiProperty(
     *     identifier=true
     * )
     */
    private UuidV4 $id;

    public function __construct(UuidV4 $id)
    {
        $this->id = $id;
    }

    public function getId(): UuidV4
    {
        return $this->id;
    }

    public function setId(UuidV4 $id): void
    {
        $this->id = $id;
    }
}
