<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiProperty;
use App\Controller\PreUpgradeNotesController;
use App\Controller\PostUpgradeNotesController;
use Symfony\Component\Uid\UuidV4;

/**
 * @ApiResource(
 *     paginationEnabled=false,
 *     collectionOperations={
 *         "getPreUpgradeNotes"={
 *              "method"="GET",
 *              "path"="upgrade_notes/pre",
 *              "controller"=PreUpgradeNotesController::class,
 *              "openapi_context"={
 *                  "summary"="Retrieves pre-upgrade notes",
 *                  "parameters"={
 *                      {
 *                          "name"="scenarioId",
 *                          "in"="query",
 *                          "required"=true,
 *                          "description"="Scenario ID",
 *                          "schema"={"type"="string"}
 *                      }
 *                  },
 *              },
 *          },
 *          "getPostUpgradeNotes"={
 *              "method"="GET",
 *              "path"="upgrade_notes/post",
 *              "controller"=PostUpgradeNotesController::class,
 *              "openapi_context"={
 *                  "summary"="Retrieves post-upgrade notes",
 *                  "parameters"={
 *                      {
 *                          "name"="scenarioId",
 *                          "in"="query",
 *                          "required"=true,
 *                          "description"="Scenario ID",
 *                          "schema"={"type"="string"}
 *                      }
 *                  },
 *              },
 *          },
 *     },
 *     itemOperations={
 *          "get"={
 *              "controller"=NotFoundAction::class,
 *              "read"=false,
 *              "output"=false
 *          }
 *     }
 * )
 */
class UpgradeNote
{
    /**
     * @ApiProperty(
     *     identifier=true
     * )
     */
    private UuidV4 $id;

    private string $authorName;

    private string $moduleName;

    private array $notes;

    public function __construct(
        string $moduleName,
        string $authorName,
        array $notes
    ) {
        $this->id         = UuidV4::v4();
        $this->authorName = $authorName;
        $this->moduleName = $moduleName;
        $this->notes      = $notes;
    }

    /**
     * @return UuidV4
     */
    public function getId(): UuidV4
    {
        return $this->id;
    }

    /**
     * @param UuidV4 $id
     */
    public function setId(UuidV4 $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getAuthorName(): string
    {
        return $this->authorName;
    }

    /**
     * @param string $authorName
     */
    public function setAuthorName(string $authorName): void
    {
        $this->authorName = $authorName;
    }

    /**
     * @return string
     */
    public function getModuleName(): string
    {
        return $this->moduleName;
    }

    /**
     * @param string $moduleName
     */
    public function setModuleName(string $moduleName): void
    {
        $this->moduleName = $moduleName;
    }

    /**
     * @return array
     */
    public function getNotes(): array
    {
        return $this->notes;
    }

    /**
     * @param array $notes
     */
    public function setNotes(array $notes): void
    {
        $this->notes = $notes;
    }
}
