<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(
 *     name="service_storage"
 * )
 */
class Storage
{
    /**
     * @ORM\Id
     * @ORM\Column(type="string", length=32)
     */
    private string $recordKey;

    /**
     * @ORM\Column(type="string")
     */
    private string $value;

    public function getKey(): string
    {
        return $this->recordKey;
    }

    public function setKey(string $recordKey): void
    {
        $this->recordKey = $recordKey;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function setValue(string $value): void
    {
        $this->value = $value;
    }
}
