<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * This entity is used only for session table creation, so no need to create getters and setters or other code
 *
 * @ORM\Entity
 * @ORM\Table(name="sessions", indexes={
 *     @ORM\Index(name="sessions_sess_lifetime_idx", columns={"sess_lifetime"})
 * })
 */
class Session
{
    /**
     * @ORM\Column(name="sess_id", type="binary", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private string $sessId;

    /**
     * @ORM\Column(name="sess_data", type="blob", length=16777215, nullable=false)
     */
    private string $sessData;

    /**
     * @ORM\Column(name="sess_lifetime", type="integer", nullable=false, options={"unsigned"=true})
     */
    private int $sessLifetime;

    /**
     * @ORM\Column(name="sess_time", type="integer", nullable=false, options={"unsigned"=true})
     */
    private int $sessTime;
}
