<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiProperty;
use App\Controller\ModuleUpgradesController;

/**
 * @ApiResource(
 *     paginationEnabled=false,
 *     collectionOperations={
 *         "get"={
 *              "controller"=ModuleUpgradesController::class,
 *              "openapi_context"={
 *                  "parameters"={
 *                      {
 *                          "name"="withAdditionalInfo",
 *                          "in"="query",
 *                          "required"=false,
 *                          "description"="If true, additional info (changelogs) would be provided",
 *                          "schema"={"type"="bool"},
 *                          "example"="true"
 *                      }
 *                  }
 *             },
 *          },
 *     },
 *     itemOperations={
 *          "get"={
 *              "controller"=NotFoundAction::class,
 *              "read"=false,
 *              "output"=false
 *          }
 *     }
 * )
 */
class ModuleUpgrade
{
    /**
     * @ApiProperty(
     *     identifier=true
     * )
     */
    private string $moduleId;

    private array $buildUpgrade;

    private array $minorUpgrade;

    private array $majorUpgrade;

    private array $delayedUpgrade;

    private array $moduleData;

    public function __construct(
        string $moduleId,
        array $upgrades,
        array $moduleData = []
    ) {
        $this->moduleId       = $moduleId;
        $this->buildUpgrade   = $upgrades['build'] ?? [];
        $this->minorUpgrade   = $upgrades['minor'] ?? [];
        $this->majorUpgrade   = $upgrades['major'] ?? [];
        $this->delayedUpgrade = $upgrades['delayedUpgrade'] ?? [];
        $this->moduleData     = $moduleData;
    }

    public function getModuleId(): string
    {
        return $this->moduleId;
    }

    public function setModuleId(string $moduleId): void
    {
        $this->moduleId = $moduleId;
    }

    public function getBuildUpgrade(): array
    {
        return $this->buildUpgrade;
    }

    public function setBuildUpgrade(array $buildUpgrade): void
    {
        $this->buildUpgrade = $buildUpgrade;
    }

    public function getMinorUpgrade(): array
    {
        return $this->minorUpgrade;
    }

    public function setMinorUpgrade(array $minorUpgrade): void
    {
        $this->minorUpgrade = $minorUpgrade;
    }

    public function getMajorUpgrade(): array
    {
        return $this->majorUpgrade;
    }

    public function setMajorUpgrade(array $majorUpgrade): void
    {
        $this->majorUpgrade = $majorUpgrade;
    }

    public function getDelayedUpgrade(): array
    {
        return $this->delayedUpgrade;
    }

    public function setDelayedUpgrade(array $delayedUpgrade): void
    {
        $this->delayedUpgrade = $delayedUpgrade;
    }

    public function getModuleData(): array
    {
        return $this->moduleData;
    }

    public function setModuleData(array $moduleData): void
    {
        $this->moduleData = $moduleData;
    }
}
