<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiProperty;
use App\Controller\IntegrityViolationsController;
use Symfony\Component\Uid\UuidV4;

/**
 * @ApiResource(
 *     paginationEnabled=false,
 *     collectionOperations={
 *         "get"={
 *              "controller"=IntegrityViolationsController::class,
 *              "openapi_context"={
 *                  "parameters"={
 *                      {
 *                          "name"="scenarioId",
 *                          "in"="query",
 *                          "required"=true,
 *                          "description"="Scenario ID",
 *                          "schema"={"type"="string"}
 *                      }
 *                  }
 *              },
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *              "controller"=NotFoundAction::class,
 *              "read"=false,
 *              "output"=false
 *          }
 *     }
 * )
 */
class IntegrityViolation
{
    /**
     * @ApiProperty(
     *     identifier=true
     * )
     */
    private UuidV4 $id;

    private string $filePath;

    public function __construct(string $filePath)
    {
        $this->id       = UuidV4::v4();
        $this->filePath = $filePath;
    }

    /**
     * @return UuidV4
     */
    public function getId(): UuidV4
    {
        return $this->id;
    }

    /**
     * @param UuidV4 $id
     */
    public function setId(UuidV4 $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getFilePath(): string
    {
        return $this->filePath;
    }

    /**
     * @param string $filePath
     */
    public function setFilePath(string $filePath): void
    {
        $this->filePath = $filePath;
    }
}
