<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiProperty;
use App\Controller\UpgradeEntriesController;
use App\Controller\IncorrectPermissionsCommandController;
use Symfony\Component\Uid\UuidV4;

/**
 * @ApiResource(
 *     paginationEnabled=false,
 *     collectionOperations={
 *         "get"={
 *              "controller"=IncorrectPermissionsCommandController::class,
 *              "openapi_context"={
 *                  "parameters"={
 *                      {
 *                          "name"="scenarioId",
 *                          "in"="query",
 *                          "required"=true,
 *                          "description"="Scenario ID",
 *                          "schema"={"type"="string"}
 *                      }
 *                  }
 *              },
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *              "controller"=NotFoundAction::class,
 *              "read"=false,
 *              "output"=false
 *          }
 *     }
 * )
 */
class IncorrectPermissionsCommand
{
    /**
     * @ApiProperty(
     *     identifier=true
     * )
     */
    private UuidV4 $id;

    private string $cmd;

    public function __construct(string $cmd)
    {
        $this->id  = UuidV4::v4();
        $this->cmd = $cmd;
    }

    /**
     * @return UuidV4
     */
    public function getId(): UuidV4
    {
        return $this->id;
    }

    /**
     * @param UuidV4 $id
     */
    public function setId(UuidV4 $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getCmd(): string
    {
        return $this->cmd;
    }

    /**
     * @param string $cmd
     */
    public function setCmd(string $cmd): void
    {
        $this->cmd = $cmd;
    }
}
