<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Entity;

final class CheckRequirementsResult
{
    public const CANT_DISABLE_BY_BACK_DEPENDENCY_REASON = 'cant-disable-by-back-dependency';
    public const CANT_DISABLE_BY_MODULE_PROPERTY_REASON = 'cant-disable-by-module-property';
    public const CANT_ENABLE_BY_DEPENDENCY_REASON       = 'cant-enable-by-dependency';
    public const CANT_ENABLE_BY_INCOMPATIBLE_REASON     = 'cant-enable-by-incompatible';
    public const CANT_ENABLE_BY_VERSION_REASON          = 'cant-enable-by-minorRequiredCoreVersion';
    public const CONFLICT_WITH_DISABLE_REASON           = 'conflict-with-disable';
    public const CONFLICT_WITH_ENABLE_REASON            = 'conflict-with-enable';

    /**
     * @var array Modules allowed for enable (with dependencies)
     */
    private array $toEnable = [];

    /**
     * @var array Modules allowed for disable (with incompatibles)
     */
    private array $toDisable = [];

    /**
     * @var array Modules allowed for remove
     */
    private array $toRemove = [];

    /**
     * @var array Modules prevented to enable
     */
    private array $cantEnable = [];

    /**
     * @var array Modules prevented to disable
     */
    private array $cantDisable = [];

    /**
     * @var array Allowed actions
     */
    private array $successActions = [];

    /**
     * @var array Disallowed actions
     */
    private array $failedActions = [];

    /**
     * @return array
     */
    public function getToEnable(): array
    {
        return $this->toEnable;
    }

    /**
     * @param array $toEnable
     */
    public function setToEnable(array $toEnable): void
    {
        $this->toEnable = $toEnable;
    }

    /**
     * @param string $toEnable
     */
    public function addToEnable(string $toEnable): void
    {
        $this->toEnable[] = $toEnable;
    }

    /**
     * @param string $toEnable
     */
    public function removeToEnable(string $toEnable): void
    {
        $this->toEnable = array_diff($this->toEnable, [$toEnable]);
    }

    /**
     * @return array
     */
    public function getToDisable(): array
    {
        return $this->toDisable;
    }

    /**
     * @param array $toDisable
     */
    public function setToDisable(array $toDisable): void
    {
        $this->toDisable = $toDisable;
    }

    /**
     * @param string $toDisable
     */
    public function addToDisable(string $toDisable): void
    {
        $this->toDisable[] = $toDisable;
    }

    /**
     * @param string $toDisable
     */
    public function removeToDisable(string $toDisable): void
    {
        $this->toDisable = array_diff($this->toDisable, [$toDisable]);
    }

    /**
     * @return array
     */
    public function getToRemove(): array
    {
        return $this->toRemove;
    }

    /**
     * @param array $toRemove
     */
    public function setToRemove(array $toRemove): void
    {
        $this->toRemove = $toRemove;
    }

    /**
     * @param string $toRemove
     */
    public function addToRemove(string $toRemove): void
    {
        $this->toRemove[] = $toRemove;
    }

    /**
     * @param string $toRemove
     */
    public function removeToRemove(string $toRemove): void
    {
        $this->toRemove = array_diff($this->toRemove, [$toRemove]);
    }

    /**
     * @return array
     */
    public function getCantEnable(): array
    {
        return $this->cantEnable;
    }

    /**
     * @param array $cantEnable
     */
    public function setCantEnable(array $cantEnable): void
    {
        $this->cantEnable = $cantEnable;
    }

    /**
     * @param string $id
     * @param string $reason
     * @param array  $data
     */
    public function addCantEnable(string $id, string $reason, array $data = []): void
    {
        $this->cantEnable[] = [$id, $reason, $data];
    }

    /**
     * @return array
     */
    public function getCantDisable(): array
    {
        return $this->cantDisable;
    }

    /**
     * @param array $cantDisable
     */
    public function setCantDisable(array $cantDisable): void
    {
        $this->cantDisable = $cantDisable;
    }

    /**
     * @param string $id
     * @param string $reason
     * @param array  $data
     */
    public function addCantDisable(string $id, string $reason, array $data = []): void
    {
        $this->cantDisable[] = [$id, $reason, $data];
    }

    public function getCantReasons(): array
    {
        $resultArr = [];
        foreach (['cantDisable' => $this->getCantDisable(), 'cantEnable' => $this->getCantEnable()] as $type => $typeData) {
            if (!$typeData) {
                continue;
            }

            foreach ($typeData as $reason) {
                unset($reason[0]);
                $resultArr[$type][] = array_values($reason);
            }
        }

        return $resultArr;
    }

    public function getSuccessActions(): array
    {
        return $this->successActions;
    }

    /**
     * @param array $successActions
     */
    public function setSuccessActions(array $successActions): void
    {
        $this->successActions = $successActions;
    }

    /**
     * @param string $id
     * @param string $action
     */
    public function addSuccessActions(string $id, string $action): void
    {
        $this->successActions[$id] = $action;
    }

    /**
     * @return array
     */
    public function getFailedActions(): array
    {
        return $this->failedActions;
    }

    /**
     * @param array $failedActions
     */
    public function setFailedActions(array $failedActions): void
    {
        $this->failedActions = $failedActions;
    }

    /**
     * @param string $id
     * @param string $action
     */
    public function addFailedActions(string $id, string $action): void
    {
        $this->failedActions[$id] = $action;
    }
}
