<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Domain;

use Symfony\Component\HttpFoundation\RequestStack;

final class ShopURLs
{
    private object $config;

    private bool $forceUseHttp = false;

    public function __construct($config, RequestStack $requestStack)
    {
        $this->config = (object) $config;

        if (
            !$this->config->isSecure
            && $requestStack->getCurrentRequest()
            && !$requestStack->getCurrentRequest()->isSecure()
        ) {
            // the admin area is opened via http protocol
            $this->forceUseHttp = true;
        }
    }

    public function getShopDomain(): string
    {
        return $this->forceUseHttp ? $this->config->httpHost : $this->config->httpsHost;
    }

    public function getShopURL(): string
    {
        $protocol = $this->forceUseHttp ? 'http' : 'https';
        $host     = $this->getShopDomain();

        return "{$protocol}://{$host}{$this->config->webDir}";
    }

    public function getShopWebDir(): string
    {
        return $this->config->webDir;
    }
}
