<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Domain;

use App\Operation\ExecuteShellCommand;

final class ServiceToolConsole
{
    private string $sourcePath;

    private ExecuteShellCommand $executeShellCommand;

    public function __construct(
        XCart $XCart,
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->sourcePath          = $XCart->getSourcePath();
        $this->executeShellCommand = $executeShellCommand;
    }

    public function run(string $command, array $params = []): string
    {
        return ($this->executeShellCommand)("php ./bin/service {$command} " . implode(' ', $params), $this->sourcePath);
    }
}
