<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Domain;

use Iterator;
use SplFileInfo;
use Symfony\Component\Filesystem\Filesystem;

class Backup
{
    private string $backupPath;

    private string $packsPath;

    private string $sourcePath;

    private Filesystem $fileSystem;

    public function __construct(
        XCart      $XCart,
        Filesystem $filesystem
    ) {
        $this->sourcePath = $XCart->getSourcePath();
        $this->packsPath = $XCart->getPacksPath();
        $this->fileSystem = $filesystem;
    }

    public function create(string $scenarioId): void
    {
        $this->backupPath = "{$this->packsPath}{$scenarioId}/";

        $this->fileSystem->remove($this->backupPath);
        $this->fileSystem->mkdir($this->backupPath);
    }

    /**
     * @param string|Iterator $file
     */
    public function addReplaceRecord($file): void
    {
        if ($file instanceof Iterator) {
            /** @var SplFileInfo $item */
            foreach ($file as $item) {
                $source      = $item->getRealPath();
                $destination = str_replace($this->sourcePath, $this->backupPath, $source);
                $this->fileSystem->copy($source, $destination);
            }
        } elseif (is_string($file)) {
            $this->fileSystem->copy("{$this->sourcePath}{$file}", "{$this->backupPath}{$file}");
        }
    }

    public function addCreateRecord(string $file): void
    {
        file_put_contents("{$this->backupPath}.metadata", $file . \PHP_EOL, \FILE_APPEND);
    }
}
