<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Module;
use App\Entity\Scenario;
use App\Repository\ModuleRepository;
use Symfony\Component\Yaml\Yaml;

final class UpdateModuleStructures extends Step
{
    private XCart $XCart;

    private ModuleRepository $moduleRepository;

    public function __construct(
        XCart                  $XCart,
        ModuleRepository       $moduleRepository
    ) {
        $this->XCart            = $XCart;
        $this->moduleRepository = $moduleRepository;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Update module structures';
    }

    protected function execute(): void
    {
        $enabledModuleIds = $this->moduleRepository->getEnabledIds();

        if ($enabledModuleIds) {
            $enabledModulesData = $this->XCart->run(
                'xcart:service:get-protected-structures',
                $this->moduleRepository->getEnabledIds()
            );

            $enabledModulesStructure = Yaml::parse($enabledModulesData);

            foreach ($this->moduleRepository->getEnabledModules() as $module) {
                /** @var Module $module */
                $module->setStructure(
                    $enabledModulesStructure[$module->getModuleId()]
                );
            }
        }
    }
}
