<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Entity\Scenario;
use App\Operation\Build\BlockingFlag;

final class SetRebuildInBlockingState extends Step
{
    protected BlockingFlag $blockingFlag;

    /**
     * @param BlockingFlag $blockingFlag
     */
    public function __construct(BlockingFlag $blockingFlag)
    {
        $this->blockingFlag = $blockingFlag;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Blocking storefront';
    }

    protected function execute(): void
    {
        $this->blockingFlag->create((string) $this->getScenario()->getId());
    }
}
