<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;
use App\Marketplace\MarketplaceStorage;

final class SetCoreServiceData extends Step
{
    private XCart $XCart;
    private MarketplaceStorage $storage;

    public function __construct(
        XCart $XCart,
        MarketplaceStorage $storage
    ) {
        $this->XCart   = $XCart;
        $this->storage = $storage;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Set core service data';
    }

    protected function execute(): void
    {
        if (!$this->storage->getValue('XCartInstallationDate')) {
            $this->storage->setValue('XCartInstallationDate', (string) time());
        }

        $this->storage->setValue('XCartCoreVersion', $this->XCart->getCoreVersion());
    }
}
