<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;

final class ResizeImages extends Step
{
    private XCart $XCart;

    public function __construct(XCart $XCart)
    {
        $this->XCart = $XCart;
    }

    protected function canApply(): bool
    {
        return $this->getScenario()->getType() === Scenario::TYPE_INSTALL && $this->needResize();
    }

    protected function getInitMessage(): string
    {
        return 'Resize all images';
    }

    protected function execute(): void
    {
        $this->XCart->run('xcart:service:resize-images');
    }

    private function needResize()
    {
        return
            isset($this->getStepData()['resizeAllImages'])
            && $this->getStepData()['resizeAllImages'] === 'yes';
    }
}
