<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;
use Throwable;

final class RequestWorkersToStop extends Step
{
    private XCart $xcart;

    public function __construct(XCart $xcart)
    {
        $this->xcart = $xcart;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Requesting workers to stop';
    }

    protected function execute(): void
    {
        try {
            $this->xcart->run('messenger:stop-workers');
        } catch (Throwable $e) {
            $this->getOutput()->addEndMessage($e->getMessage());
        }
    }
}
