<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;
use App\Operation\Build\PrepareFilesystem;

final class PrepareFS extends Step
{
    private XCart $XCart;

    private PrepareFilesystem $prepareFilesystem;

    public function __construct(
        XCart $XCart,
        PrepareFilesystem $prepareFilesystem
    ) {
        $this->XCart             = $XCart;
        $this->prepareFilesystem = $prepareFilesystem;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Prepare filesystem (remove some files and dirs)';
    }

    protected function execute(): void
    {
        $dirs = array_map(
            function ($item) {
                return $this->XCart->getSourcePath() . $item;
            },
            $this->getListToRemove()
        );

        ($this->prepareFilesystem)([], $dirs);
    }

    private function getListToRemove(): array
    {
        $result = [
            'var/locale',
            'public/var/resources',
            'var/datacache',
            'var/run',
        ];

        if ($this->getScenario()->getType() === Scenario::TYPE_INSTALL) {
            $result = array_merge($result, [
                'var/log',
            ]);
        }

        return $result;
    }
}
