<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;

final class InstallDependencies extends Step
{
    private XCart $XCart;

    public function __construct(XCart $XCart)
    {
        $this->XCart = $XCart;
    }

    protected function canApply(): bool
    {
        return $this->getScenario()->getType() === Scenario::TYPE_INSTALL;
    }

    protected function getInitMessage(): string
    {
        return 'Install dependencies';
    }

    protected function execute(): void
    {
        $this->XCart->runComposer('install', ['--no-scripts']);
    }
}
