<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;

final class InstallAssets extends Step
{
    private XCart $XCart;

    public function __construct(XCart $XCart) {
        $this->XCart = $XCart;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Install assets';
    }

    protected function execute(): void
    {
        $this->XCart->run('assets:install');
        $this->XCart->run('xcart:assets:install');
    }
}
