<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;
use JsonException;

final class CreateAdminProfile extends Step
{
    private XCart $XCart;

    public function __construct(XCart $XCart)
    {
        $this->XCart = $XCart;
    }

    protected function canApply(): bool
    {
        return $this->getScenario()->getType() === Scenario::TYPE_INSTALL
            && ($this->getStepData()['login'] ?? '')
            && ($this->getStepData()['password'] ?? '');
    }

    protected function getInitMessage(): string
    {
        return 'Create admin profile';
    }

    /**
     * @throws JsonException
     */
    protected function execute(): void
    {
        $login    = $this->getStepData()['login'];
        $password = $this->getStepData()['password'];
        $lang     = $this->getStepData()['lang'] ?? 'en';

        $this->XCart->run(
            'xcart:service:load-fixtures',
            [
                'sql/xlite_admin_profile.yaml',
                '--params',
                json_encode(
                    [
                        '$login'                   => $login,
                        '$password'                => $password,
                        '$siteAdministratorEmails' => serialize([$login]),
                        '$lang'                    => $lang
                    ],
                    JSON_THROW_ON_ERROR
                ),
            ]
        );
    }
}
