<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\ServiceToolConsole;
use App\Entity\Scenario;

final class ClearServiceToolCache extends Step
{
    private ServiceToolConsole $serviceToolConsole;

    public function __construct(
        ServiceToolConsole $serviceToolConsole
    ) {
        $this->serviceToolConsole  = $serviceToolConsole;
    }

    protected function canApply(): bool
    {
        return $this->getScenario()->getType() === Scenario::TYPE_REBUILD;
    }

    protected function getInitMessage(): string
    {
        return 'Clear service tool cache';
    }

    protected function execute(): void
    {
        $this->serviceToolConsole->run('cache:clear');
    }
}
