<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Entity\Module;
use App\Entity\Scenario;

final class CallPreHooks extends CallHooks
{
    protected function canApply(): bool
    {
        return $this->getScenario()->getType() === Scenario::TYPE_REBUILD
            && ($this->getStepData()['hooks']['disable'] ?? false);
    }

    protected function getInitMessage(): string
    {
        return 'Run disable/remove hooks';
    }

    protected function generateHookList(): void
    {
        $hooks = [
            'disable' => [],
        ];

        foreach ($this->getScenario()->getTransitions() as $moduleId => $transition) {
            if (
                $transition['stateBefore'] === Module::STATE_ENABLED
                && (
                    $transition['stateAfter'] === Module::STATE_INSTALLED
                    || $transition['stateAfter'] === Module::STATE_REMOVED
                )
            ) {
                $hooks['disable'][] = [
                    'moduleId' => $moduleId,
                ];
            }

            if ($transition['stateAfter'] === Module::STATE_REMOVED) {
                $hooks['remove'][] = [
                    'moduleId' => $moduleId,
                ];
            }
        }

        $this->setStepData(['hooks' => $hooks]);
    }
}
