<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Domain\XCart;
use App\Entity\Scenario;
use JsonException;

abstract class CallHooks extends Step
{
    protected XCart $XCart;

    public function __construct(XCart $XCart)
    {
        $this->XCart = $XCart;
    }

    abstract protected function generateHookList(): void;

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function init(): void
    {
        if (!$this->hasStepData()) {
            $this->generateHookList();
        }
    }

    protected function getInitMessage(): string
    {
        return 'Run hooks';
    }

    /**
     * @throws JsonException
     */
    protected function execute(): void
    {
        $this->XCart->run(
            'xcart:service:ll:call-module-hooks',
            [
                json_encode($this->getStepData()['hooks'], JSON_THROW_ON_ERROR),
            ]
        );
    }
}
