<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Deployment\Step;

use App\Entity\Scenario;
use App\Operation\Build\BuildCodeCache;

final class BuildCode extends Step
{
    private BuildCodeCache $buildCodeCache;

    public function __construct(
        BuildCodeCache $buildCodeCache
    ) {
        $this->buildCodeCache = $buildCodeCache;
    }

    protected function canApply(): bool
    {
        return in_array(
            $this->getScenario()->getType(),
            [
                Scenario::TYPE_INSTALL,
                Scenario::TYPE_REBUILD,
                Scenario::TYPE_UPGRADE,
                Scenario::TYPE_UPGRADE_54_TO_55,
            ],
            true
        );
    }

    protected function getInitMessage(): string
    {
        return 'Build code cache';
    }

    protected function execute(): void
    {
        ($this->buildCodeCache)();
    }
}
