<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use App\Domain\HookManagerDomain;

class AddLifetimeHooksPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container)
    {
        $hookManagerDomainService = $container->getDefinition(HookManagerDomain::class);

        foreach ($container->findTaggedServiceIds('xcart.lifetime-hook', true) as $serviceId => $tags) {
            foreach ($tags as $tag) {
                $hookType = $tag['type'] ?? HookManagerDomain::HOOK_TYPE_UPGRADE;

                $hook = [
                    'hookType' => $hookType,
                    'object'   => new Reference($serviceId),
                    'method'   => $tag['method'] ?? "on{$hookType}",
                ];

                if ($hookType === HookManagerDomain::HOOK_TYPE_UPGRADE) {
                    $hook['version'] = $tag['version'] ?? '';
                }

                $hookManagerDomainService->addMethodCall('addHook', [$hook]);
            }
        }
    }
}
