<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\DataTransformer;

use ApiPlatform\Core\DataTransformer\DataTransformerInterface;
use App\DTO\Input\NonPersistentScenarioInput;
use App\DTO\Input\ScenarioInput;
use App\Entity\Scenario;
use App\Exception\BuildException;
use App\Operation\Build\GenerateTransitions;
use App\Operation\Build\RebuildFlag;
use JsonException;
use MJS\TopSort\CircularDependencyException;
use MJS\TopSort\ElementNotFoundException;

class NonPersistentScenarioInputDataTransformer implements DataTransformerInterface
{
    private GenerateTransitions $generateTransitions;

    public function __construct(GenerateTransitions $generateTransitions)
    {
        $this->generateTransitions = $generateTransitions;
    }

    /**
     * @param ScenarioInput $object
     * @param string        $to
     * @param array         $context
     *
     * @return Scenario
     * @throws BuildException
     * @throws CircularDependencyException
     * @throws ElementNotFoundException
     * @throws JsonException
     */
    public function transform($object, string $to, array $context = [])
    {
        $modulesToEnable  = $object->modulesToEnable ?? [];
        $modulesToDisable = $object->modulesToDisable ?? [];
        $modulesToRemove = $object->modulesToRemove ?? [];

        $transitions = ($this->generateTransitions)($modulesToEnable, $modulesToDisable, $modulesToRemove);

        $scenario = new Scenario();
        $scenario->setTransitions($transitions);

        return $scenario;
    }

    public function supportsTransformation($data, string $to, array $context = []): bool
    {
        if ($data instanceof Scenario) {
            return false;
        }

        return (
            $to === Scenario::class
            && $context['input']['class'] === NonPersistentScenarioInput::class
        );
    }
}
