<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DataTransformer;

use App\Entity\License;
use App\Marketplace\Marketplace;
use ApiPlatform\Core\DataTransformer\DataTransformerInterface;
use ApiPlatform\Core\Exception\InvalidArgumentException;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class LicenseInputDataTransformer implements DataTransformerInterface
{
    private Marketplace $marketplace;
    private ValidatorInterface $validator;

    public function __construct(
        Marketplace $marketplace,
        ValidatorInterface $validator
    ) {
        $this->marketplace = $marketplace;
        $this->validator   = $validator;
    }

    public function transform($object, string $to, array $context = []): License
    {
        $violations = $this->validator->validate($object);
        if (count($violations) > 0) {
            throw new InvalidArgumentException(sprintf("Input validations failed: %s", (string) $violations));
        }

        $wave = $object->wave ? (int) $object->wave : null;

        return $this->marketplace->registerLicense($object->licenseKey, $wave);
    }

    public function supportsTransformation($data, string $to, array $context = []): bool
    {
        if ($data instanceof License) {
            return false;
        }

        return License::class === $to && null !== ($context['input']['class'] ?? null);
    }
}
