<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DataProvider;

use App\Entity\Wave;
use App\DTO\Output\WaveOutput;
use App\Repository\LicenseRepository;
use App\Marketplace\MarketplaceClient;
use ApiPlatform\Core\DataProvider\CollectionDataProviderInterface;
use ApiPlatform\Core\DataProvider\RestrictedDataProviderInterface;

final class WavesDataProvider implements CollectionDataProviderInterface, RestrictedDataProviderInterface
{
    public const OPERATION_NAME = 'get';

    private MarketplaceClient $client;

    private LicenseRepository $licenseRepository;

    public function __construct(
        MarketplaceClient $client,
        LicenseRepository $licenseRepository
    ) {
        $this->client  = $client;
        $this->licenseRepository = $licenseRepository;
    }

    public function supports(string $resourceClass, string $operationName = null, array $context = []): bool
    {
        return $resourceClass === Wave::class && $operationName === self::OPERATION_NAME;
    }

    public function getCollection(string $resourceClass, string $operationName = null): array
    {
        $result      = [];
        $coreLicense = $this->licenseRepository->findCoreLicense();

        if ($currentWave = (int) ($coreLicense->getKeyData()['wave'] ?? null)) {
            foreach ($this->client->retrieve('get_waves') as $id => $name) {
                $output           = new WaveOutput;
                $output->id       = $id;
                $output->name     = $name;
                $output->isActive = ($currentWave === $id);

                $result[] = $output;
            }
        }

        if ($currentWave === -10) {
            array_unshift($result, [
                'id'       => -10,
                'name'     => 'Tester',
                'isActive' => true
            ]);
        }

        return $result;
    }
}
