<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DataProvider;

use ApiPlatform\Core\DataProvider\ItemDataProviderInterface;
use ApiPlatform\Core\DataProvider\RestrictedDataProviderInterface;
use App\Entity\Module;
use App\Repository\ModuleRepository;

/**
 * Modules are indexed by UUID, but it is required to get module info by Author-Name pair
 */
final class ModuleByModuleIdItemDataProvider implements ItemDataProviderInterface, RestrictedDataProviderInterface
{
    public const OPERATION_NAME = 'byModuleId';

    private ModuleRepository $moduleRepository;

    public function __construct(
        ModuleRepository $moduleRepository
    ) {
        $this->moduleRepository = $moduleRepository;
    }

    public function supports(string $resourceClass, string $operationName = null, array $context = []): bool
    {
        return $resourceClass === Module::class && $operationName === self::OPERATION_NAME;
    }

    /**
     * @param string $id String with pair "{Author}-{Name}"
     */
    public function getItem(string $resourceClass, $id, string $operationName = null, array $context = [])
    {
        return $this->moduleRepository->findByModuleId($id);
    }
}
