<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DataProvider;

use App\Entity\Module;
use App\Marketplace\MarketplaceClient;
use App\Repository\ModuleRepository;
use ApiPlatform\Core\DataProvider\CollectionDataProviderInterface;
use ApiPlatform\Core\DataProvider\RestrictedDataProviderInterface;

final class GdprModuleDataProvider implements CollectionDataProviderInterface, RestrictedDataProviderInterface
{
    public const OPERATION_NAME = 'gdpr';

    private MarketplaceClient $client;
    private ModuleRepository $moduleRepository;

    public function __construct(
        MarketplaceClient $client,
        ModuleRepository $moduleRepository
    ) {
        $this->client           = $client;
        $this->moduleRepository = $moduleRepository;
    }

    public function supports(string $resourceClass, string $operationName = null, array $context = []): bool
    {
        return $resourceClass === Module::class && $operationName === self::OPERATION_NAME;
    }

    public function getCollection(string $resourceClass, string $operationName = null): array
    {
        $modules = array_map(
            function ($moduleId) {
                $module = $this->moduleRepository->findByModuleId($moduleId);

                return $module->isEnabled() ? $module : null;
            },
            $this->client->retrieve('get_gdpr_addons_list')
        );

        return array_filter($modules);
    }
}
