<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DataProvider;

use ApiPlatform\Core\DataProvider\ItemDataProviderInterface;
use ApiPlatform\Core\DataProvider\RestrictedDataProviderInterface;
use App\Entity\License;
use App\Marketplace\Marketplace;
use App\Repository\LicenseRepository;
use Symfony\Component\Serializer\SerializerInterface;

final class CoreLicenseDataProvider implements ItemDataProviderInterface, RestrictedDataProviderInterface
{
    public const OPERATION_NAME = 'core';

    private Marketplace $marketplace;
    private LicenseRepository $licenseRepository;
    private SerializerInterface $serializer;

    public function __construct(
        Marketplace $marketplace,
        LicenseRepository $licenseRepository,
        SerializerInterface $serializer
    ) {
        $this->marketplace       = $marketplace;
        $this->licenseRepository = $licenseRepository;
        $this->serializer        = $serializer;
    }

    public function supports(string $resourceClass, string $operationName = null, array $context = []): bool
    {
        return $resourceClass === License::class
            && preg_match('#/licenses/core$|\?#', $context['request_uri']);
    }

    public function getItem(string $resourceClass, $id, string $operationName = null, array $context = []): License
    {
        return $this->licenseRepository->findCoreLicense() ?? $this->licenseRepository->createCoreLicense();
    }
}
