<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DTO\Output;

class ModuleOutput
{
    /**
     * @var string
     */
    public string $id;

    /**
     * @var string
     */
    public string $type;

    /**
     * @var string
     */
    public string $state;

    /**
     * @var bool
     */
    public bool $isCustom;

    /**
     * @var bool
     */
    public bool $hasLocalFiles;

    /**
     * @var string
     */
    public string $author;

    /**
     * @var string
     */
    public string $name;

    /**
     * @var string
     */
    public string $authorName;

    /**
     * @var string
     */
    public string $moduleName;

    /**
     * @var string
     */
    public string $description;

    /**
     * @var string
     */
    public string $version;

    /**
     * @var string
     */
    public string $scenarioState;

    /**
     * @var array
     */
    public array $actions;

    /**
     * @var string
     */
    public string $pageUrl;

    /**
     * This structure is used (see addCantDisable function in CheckRequirements class)
     * [string moduleId, string reason, array data]
     *
     * @var array
     */
    public array $warning;

    public int $enabledDate;
}
