<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\DTO\Input;

use ApiPlatform\Core\Annotation\ApiProperty;

class NonPersistentScenarioInput
{
    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "type"="array",
     *             "items"={"type"="string"},
     *             "example"={"CDev-Sale", "XC-FreeShipping"}
     *         }
     *     }
     * )
     * @var array
     */
    public array $modulesToEnable;

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "type"="array",
     *             "items"={"type"="string"},
     *             "example"={"CDev-GoSocial", "XC-News"}
     *         }
     *     }
     * )
     * @var array
     */
    public array $modulesToDisable;

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "type"="array",
     *             "items"={"type"="string"},
     *             "example"={"CDev-GoSocial", "XC-News"}
     *         }
     *     }
     * )
     * @var array
     */
    public array $modulesToRemove;

}
