<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Controller;

use App\Domain\ShopURLs;
use App\Entity\Scenario;
use App\Operation\Build\Upgrade54To55\CreateSession;
use App\Operation\Build\Upgrade54To55\GenerateTransitions;
use App\Operation\Build\Upgrade54To55\GetPostUpgradeNotes;
use App\Operation\Build\Upgrade54To55\MovePublicFiles;
use App\Operation\Build\Upgrade54To55\MoveServiceToolData;
use App\Operation\Build\Upgrade54To55\SetServiceData;
use Exception;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class Upgrade54to55Controller extends AbstractController
{
    private CreateSession $createSession;

    private SetServiceData $setServiceData;

    private GetPostUpgradeNotes $getPostUpgradeNotes;

    private MoveServiceToolData $moveServiceToolData;

    private MovePublicFiles $movePublicFiles;

    private GenerateTransitions $generateTransitions;

    private EntityManagerInterface $entityManager;

    private ShopURLs $shopURLs;

    public function __construct(
        CreateSession $createSession,
        SetServiceData $setServiceData,
        GetPostUpgradeNotes $getPostUpgradeNotes,
        MoveServiceToolData $moveServiceToolData,
        MovePublicFiles $movePublicFile,
        GenerateTransitions $generateTransitions,
        ShopURLs $shopURLs,
        EntityManagerInterface $entityManager
    ) {
        $this->createSession       = $createSession;
        $this->setServiceData      = $setServiceData;
        $this->getPostUpgradeNotes = $getPostUpgradeNotes;
        $this->moveServiceToolData = $moveServiceToolData;
        $this->movePublicFiles     = $movePublicFile;
        $this->generateTransitions = $generateTransitions;
        $this->shopURLs            = $shopURLs;
        $this->entityManager       = $entityManager;
    }

    /**
     * @Route("/upgrade-54-to-55", name="upgrade_54_to_55")
     * @throws Exception
     */
    public function upgrade54to55(Request $request): Response
    {
        ($this->createSession)(
            $request->cookies->get('recent_login')
        );

        ($this->moveServiceToolData)();
        ($this->movePublicFiles)();

        ($this->setServiceData)();

        $transitions      = ($this->generateTransitions)();
        $postUpgradeNotes = ($this->getPostUpgradeNotes)($transitions);

        $scenario = new Scenario();
        $scenario->setType(Scenario::TYPE_UPGRADE_54_TO_55);
        $scenario->setTransitions($transitions);
        $scenario->setMetaData(['postUpgradeNotes' => $postUpgradeNotes]);

        $this->entityManager->persist($scenario);
        $this->entityManager->flush();

        $shopUrl           = $this->shopURLs->getShopURL();
        $successRebuildUrl = urlencode("{$shopUrl}/admin/?target=apps#/success-rebuild?");

        $returnUrl = "{$shopUrl}/public/upgrade.html"
            . "?scenarioId={$scenario->getId()}"
            . "&returnURL={$successRebuildUrl}"
            . "&xcUrl={$shopUrl}"
            . "&isUpgradeTo55=1";

        return $this->redirect($returnUrl);
    }
}