<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Controller;

use App\Entity\Scenario;
use App\Event\RunnerEvent;
use App\Repository\ScenarioRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Uid\UuidV4;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

final class StartUpgradeScenarioController extends AbstractController
{
    public function __invoke(
        Request $request,
        EventDispatcherInterface $eventDispatcher,
        ScenarioRepository $scenarioRepository
    ): Scenario {
        $scenarioId = new UuidV4($request->get('id'));
        $scenario   = $scenarioRepository->findById($scenarioId);

        $runnerEvent = new RunnerEvent();
        $runnerEvent->setScenario($scenario);

        $eventDispatcher->dispatch($runnerEvent, 'service-tool.runner.start');

        return $scenario;
    }
}
