<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Controller;

use App\Entity\Scenario;
use App\Exception\GetHashException;
use App\Operation\Build\Upgrade\GenerateUpgradeEntries;
use App\Repository\ScenarioRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Uid\UuidV4;

final class SetUpgradeEntriesController extends AbstractController
{
    /**
     * @throws GetHashException
     */
    public function __invoke(
        Request $request,
        GenerateUpgradeEntries $generateUpgradeEntries,
        ScenarioRepository $scenarioRepository
    ): Scenario {
        $scenarioId = new UuidV4($request->get('id'));

        $scenario         = $scenarioRepository->findById($scenarioId);
        $scenarioMetadata = $scenario->getMetaData();
        $modulesToUpgrade = $scenarioMetadata['modulesToUpgrade'] ?? [];

        $upgradeEntries = ($generateUpgradeEntries)($modulesToUpgrade);

        $scenarioMetadata['upgradeEntries'] = $upgradeEntries;

        $scenario->setMetaData($scenarioMetadata);

        return $scenario;
    }
}
