<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Controller;

use App\Entity\UpgradeNote;

final class PostUpgradeNotesController extends AbstractUpgradeNotesController
{
    protected function getUpgradeNoteType(): string
    {
        return 'post_upgrade';
    }

    protected function getUpgradeNotes(array $scenarioMetadata): array
    {
        if (isset($scenarioMetadata['postUpgradeNotes'])) {
            $result = [];

            foreach ($scenarioMetadata['postUpgradeNotes'] as $modulePostUpgradeNotes) {
                $result[] = new UpgradeNote(
                    $modulePostUpgradeNotes['name'],
                    $modulePostUpgradeNotes['author'],
                    array_values($modulePostUpgradeNotes['post_upgrade'])
                );
            }

            return $result;
        } else {
            return parent::getUpgradeNotes($scenarioMetadata);
        }
    }
}
