<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Controller;

use App\Domain\ServiceToolConsole;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class CacheController extends AbstractController
{
    private ServiceToolConsole $serviceToolConsole;

    public function __construct(ServiceToolConsole $serviceToolConsole)
    {
        $this->serviceToolConsole = $serviceToolConsole;
    }

    /**
     * @Route("/clear-cache", name="clear_cache")
     */
    public function clearCache(): Response
    {
        $output = $this->serviceToolConsole->run('cache:clear');

        return new Response(
            '<html><body>' . nl2br($output) . '</body></html>'
        );
    }
}