<?php

namespace App\Controller;

use App\Domain\ShopURLs;
use App\Exception\GetTokenDataException;
use App\Marketplace\Marketplace;
use App\Marketplace\MarketplaceStorage;
use Exception;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

final class AfterPurchaseOfRenewalsController extends AbstractController
{
    private Marketplace $marketplace;

    protected MarketplaceStorage $storage;

    private LoggerInterface $logger;

    public function __construct(
        Marketplace $marketplace,
        MarketplaceStorage $storage,
        LoggerInterface $logger
    ) {
        $this->marketplace = $marketplace;
        $this->storage     = $storage;
        $this->logger      = $logger;
    }

    /**
     * @Route("/after-purchase-of-renewals/", name="after_purchase_of_renewals")
     */
    public function afterPurchaseOfRenewalAction(
        Request $request,
        ShopURLs $shopURLs
    ): RedirectResponse {
        $returnUrl = $request->get('returnUrl') ?: ($shopURLs->getShopURL() . '/admin/?target=apps#/upgrade/minor/');
        $returnUrl = str_replace('/renewals/success', '', $returnUrl);
        $returnUrl = str_replace('/renewals/failure', '', $returnUrl);

        try {
            $token = $request->get('token');
            $this->processToken($token);

            $redirectResponse = new RedirectResponse("$returnUrl/renewals/success");
        } catch (Exception $e) {
            $this->logger->error($e->getMessage());

            $redirectResponse = new RedirectResponse("$returnUrl/renewals/failure");
        }

        return $redirectResponse;
    }

    /**
     * @throws GetTokenDataException
     */
    private function processToken(string $token): void
    {
        foreach ($this->marketplace->retrieveLicensesByToken($token) as $licenceKeys) {
            foreach ($licenceKeys as $licenceKey) {
                $this->marketplace->registerLicense($licenceKey);
            }
        }
    }
}
