<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Controller;

use App\Entity\UpgradeNote;
use App\Repository\ScenarioRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Uid\UuidV4;

abstract class AbstractUpgradeNotesController extends AbstractController
{
    abstract protected function getUpgradeNoteType(): string;

    public function __invoke(
        Request $request,
        ScenarioRepository $scenarioRepository
    ): array {
        $scenarioId       = new UuidV4($request->get('scenarioId'));
        $scenario         = $scenarioRepository->findById($scenarioId);
        $scenarioMetadata = $scenario->getMetaData();

        return $this->getUpgradeNotes($scenarioMetadata);
    }

    protected function getUpgradeNotes(array $scenarioMetadata): array
    {
        $result          = [];
        $upgradeNoteType = $this->getUpgradeNoteType();
        $modulesToUpgrade = $scenarioMetadata['modulesToUpgrade'] ?? [];

        foreach ($modulesToUpgrade as $module) {
            if (isset($module['docs'][$upgradeNoteType])) {
                $result[] = new UpgradeNote(
                    $module['readableName'],
                    $module['readableAuthor'],
                    array_values($module['docs'][$upgradeNoteType])
                );
            }
        }

        return $result;
    }
}
