<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command;

use App\Repository\LicenseRepository;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class RemoveLicenseCommand extends Command
{
    protected static $defaultName = 'xcst:remove-license';

    private LicenseRepository $licenseRepository;

    public function __construct(
        LicenseRepository $licenseRepository
    ) {
        parent::__construct();

        $this->licenseRepository = $licenseRepository;
    }

    protected function configure()
    {
        $help = <<< HELP
Removes license key data. 

<info>Arguments:</info>
    <fg=red;bg=gray;options=bold>--license</> - License key value
HELP;

        $this
            ->setDescription('Removes license key data.')
            ->setHelp($help)
            ->addArgument('license', InputArgument::REQUIRED, 'License key value');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $license = $input->getArgument('license');

        $this->licenseRepository->removeLicenseByKey($license);

        return Command::SUCCESS;
    }
}
