<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command;

use App\Operation\Build\RemoveActiveScenario;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class RemoveActiveScenarioCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:remove-active-scenario';

    private RemoveActiveScenario $removeActiveScenario;

    public function __construct(RemoveActiveScenario $removeActiveScenario)
    {
        parent::__construct();

        $this->removeActiveScenario = $removeActiveScenario;
    }

    protected function configure()
    {
        $this->setDescription('Removes the current operational scenario data.');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        ($this->removeActiveScenario)();

        $output->writeln('<info>Active scenario is removed</info>');

        return Command::SUCCESS;
    }
}
