<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command;

use App\Marketplace\Marketplace;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;

final class RegisterLicenseCommand extends Command
{
    protected static $defaultName = 'xcst:register-license';

    private Marketplace $marketplace;

    public function __construct(
        Marketplace $marketplace
    ) {
        parent::__construct();

        $this->marketplace = $marketplace;
    }

    protected function configure()
    {
        $help = <<< HELP
Registers a license key.

<info>Arguments:</info>
    <fg=red;bg=gray;options=bold>--license</> - License key value
HELP;

        $this
            ->setDescription('Registers a license key.')
            ->setHelp($help)
            ->addArgument('license', InputArgument::REQUIRED, 'License key value');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $license = $input->getArgument('license');

        $this->marketplace->registerLicense($license);

        return Command::SUCCESS;
    }
}
