<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\Configuration\GenerateSkinModel;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Yaml\Yaml;

final class SetSkinModelCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:set-skin-model';

    private XCart $XCart;

    private GenerateSkinModel $generateSkinModel;

    public function __construct(
        XCart $XCart,
        GenerateSkinModel $generateSkinModel
    ) {
        parent::__construct();

        $this->XCart             = $XCart;
        $this->generateSkinModel = $generateSkinModel;
    }

    protected function configure()
    {
        $this
            ->setDescription('Set skin configuration');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Generate skin model');

        $this->XCart->writeToFile('config/packages/xcart_skin_model.yaml', Yaml::dump(($this->generateSkinModel)(), 5));

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
