<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\Configuration\GenerateModules;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Yaml\Yaml;

final class SetModulesCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:set-modules';

    private XCart $XCart;

    private GenerateModules $generateModules;

    public function __construct(
        XCart $XCart,
        GenerateModules $generateModules
    ) {
        parent::__construct();

        $this->XCart           = $XCart;
        $this->generateModules = $generateModules;
    }

    protected function configure()
    {
        $this
            ->setDescription('Set modules');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Set modules');

        $this->XCart->writeToFile('config/packages/xcart_modules.yaml', Yaml::dump(($this->generateModules)(), 5));

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
